/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.data;

import java.util.Comparator;
import java.util.Locale;
import net.creeperhost.minetogether.polylib.gui.DropdownButton;
import net.creeperhost.minetogether.serverlist.gui.PublicServerEntry;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.minetogether.util.EnumFlag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SortType implements DropdownButton.DropdownEntry,
Comparator<PublicServerEntry>
{
    RANDOM{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            return 0;
        }
    }
    ,
    PLAYER{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            int o2Players;
            int o1Players = o1.getServerData().f_105370_ != null ? o1.getServerData().f_105370_.size() : 0;
            int n = o2Players = o2.getServerData().f_105370_ != null ? o2.getServerData().f_105370_.size() : 0;
            return o1Players > o2.getServerData().server.expectedPlayers ? -1 : (o1Players < o2Players ? 1 : 0);
        }
    }
    ,
    NAME{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            int ret = o1.getServerData().f_105362_.compareToIgnoreCase(o2.getServerData().f_105362_);
            return ret == 0 ? o1.getServerData().f_105362_.compareTo(o2.getServerData().f_105362_) : ret;
        }
    }
    ,
    UPTIME{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            return Long.compare(o1.getServerData().server.uptime, o2.getServerData().server.uptime);
        }
    }
    ,
    LOCATION{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            EnumFlag f2;
            EnumFlag f1 = o1.getServerData().server.getFlag();
            if (f1 == (f2 = o2.getServerData().server.getFlag())) {
                return 1;
            }
            if (f1.name().equals(Countries.getOurCountry())) {
                return f2.name().equals(Countries.getOurCountry()) ? 1 : -1;
            }
            if (f2.name().equals(Countries.getOurCountry())) {
                return f1.name().equals(Countries.getOurCountry()) ? -1 : 1;
            }
            int ret = f1.name().compareToIgnoreCase(f2.name());
            return ret == 0 ? f1.name().compareTo(f2.name()) : ret;
        }
    }
    ,
    PING{

        @Override
        public int compare(PublicServerEntry o1, PublicServerEntry o2) {
            if (o1.getServerData().f_105366_ == o2.getServerData().f_105366_) {
                return 0;
            }
            if (o1.getServerData().f_105366_ <= 0L) {
                return 1;
            }
            if (o2.getServerData().f_105366_ <= 0L) {
                return -1;
            }
            return Long.compare(o1.getServerData().f_105366_, o2.getServerData().f_105366_);
        }
    };


    @Override
    public Component getTitle(boolean isOpen) {
        return new TranslatableComponent("minetogether:screen.multiplayer.sort." + this.name().toLowerCase(Locale.ROOT));
    }
}

